/**********************************
 *    common.h                    *
 *    Colin Frayn                 *
 *    June 2002                   *
 **********************************/

/*
 This file includes all the necessary macros, defines etc...
 for most of the source '.cpp' files
*/

#ifndef COMMON_H
#define COMMON_H

/* Game details */
#define NAME "MateIn2" 
#define VER  "1.0"

/* Piece Identifiers */
#define pawn    (1)
#define rook    (2)
#define knight  (3)
#define bishop  (4)
#define queen   (5)
#define king    (6)  
#define empty   (0)

#define wpawn   (pawn)
#define wrook   (rook)
#define wknight (knight)
#define wbishop (bishop)
#define wqueen  (queen)
#define wking   (king)

#define bpawn   (-pawn)
#define brook   (-rook)
#define bknight (-knight)
#define bbishop (-bishop)
#define bqueen  (-queen)
#define bking   (-king)  

/* Piece colours */
#define WHITE   (0)
#define BLACK   (1)
#define NEUTRAL (2)
#define Opponent(x)  (1-(x))

/* A few random numbers :) */
#define MAX_MOVES         (128)
#define MAX_PV  (200)

/* Just in case... */
#ifndef NULL
#define NULL ((void *)0)
#endif

/* Many Simple Macros */
#define File(x)           (x & 7)
#define Rank(x)           (x >> 3)
#define PType(x)          (((x) >= 0) ? (x) : -(x))
#define IsWhite(x)        (( ((x)>>3) + (x) + 1 ) & 1)
#define Not(x)            (((x)==(TRUE)) ? (FALSE) : (TRUE))

/* Simple piece configurations for bitboards */
#define FullRank     (255)
#define TwoFullRanks (65535)

/* More Basic macros */
#ifndef max /*  Returns the maximum of two integers */
# define max(a,b)   (((a) > (b)) ? (a) : (b))
#endif
#ifndef min /*  Returns the minimum of two integers */
# define min(a,b)   (((a) < (b)) ? (a) : (b))
#endif

/* A slow bitcount */
#define MoreThanOnePiece(x)  ((x) && ((x)&((x)-1)))
#define OnePiece(x)          ((x) && (((x)&((x)-1)) == 0))

/* Generate an integer random number */
#include <time.h>
#define Random(a) ((a) == (0) ? (0) : (int)((double)rand() / ((double)RAND_MAX + 1) * (a)))
#define Randomise()  (srand(time(NULL)))

/* This is naghty, but what the heck. Good practice is to avoid
 * defining FALSE, but just to test for !TRUE */
#ifndef TRUE
# define TRUE    (1)
# define FALSE   (0)
#endif

/* Enumerated Ranks and Files */
#define FileA   (0)
#define FileB   (1)
#define FileC   (2)
#define FileD   (3)
#define FileE   (4)
#define FileF   (5)
#define FileG   (6)
#define FileH   (7)
#define Rank1   (7)
#define Rank2   (6)
#define Rank3   (5)
#define Rank4   (4)
#define Rank5   (3)
#define Rank6   (2)
#define Rank7   (1)
#define Rank8   (0)

/* Enumerated board squares */
#define a8 (0)
#define b8 (1)
#define c8 (2)
#define d8 (3)
#define e8 (4)
#define f8 (5)
#define g8 (6)
#define h8 (7)
#define a7 (8)
#define b7 (9)
#define c7 (10)
#define d7 (11)
#define e7 (12)
#define f7 (13)
#define g7 (14)
#define h7 (15)
#define a6 (16)
#define b6 (17)
#define c6 (18)
#define d6 (19)
#define e6 (20)
#define f6 (21)
#define g6 (22)
#define h6 (23)
#define a5 (24)
#define b5 (25)
#define c5 (26)
#define d5 (27)
#define e5 (28)
#define f5 (29)
#define g5 (30)
#define h5 (31)
#define a4 (32)
#define b4 (33)
#define c4 (34)
#define d4 (35)
#define e4 (36)
#define f4 (37)
#define g4 (38)
#define h4 (39)
#define a3 (40)
#define b3 (41)
#define c3 (42)
#define d3 (43)
#define e3 (44)
#define f3 (45)
#define g3 (46)
#define h3 (47)
#define a2 (48)
#define b2 (49)
#define c2 (50)
#define d2 (51)
#define e2 (52)
#define f2 (53)
#define g2 (54)
#define h2 (55)
#define a1 (56)
#define b1 (57)
#define c1 (58)
#define d1 (59)
#define e1 (60)
#define f1 (61)
#define g1 (62)
#define h1 (63)

/* A few precalculated bits and pieces that we need for the move generation */
#define promote_q  (MOVE)(1<<12)
#define promote_r  (MOVE)(2<<12)
#define promote_n  (MOVE)(3<<12)
#define promote_b  (MOVE)(4<<12)

/* Datatypes */
#ifdef _MSC_VER
#define longlong __int64
#else
#define longlong long long int
#endif
typedef unsigned longlong BITBOARD;
typedef unsigned longlong u64;
typedef unsigned char u8;
#ifndef BOOL
typedef int BOOL;
#endif


/*     -----===  Move Storage Classes and Macros  ===-----   */


/* MOVE is stored as the following;  (16 bits)
 * bits 1-6      : From Square
 * bits 7-12     : To Square
 * bits 13-15    : Promotion piece {0-4} = {None,Q,R,N,B}
 * bit  16       : EP Capture?
 */

typedef short int MOVE;

/* Macros */
#define EP_FLAG           (1<<15)
#define IsEP(x)           ((x) & EP_FLAG)
#define IsPromote(x)      (((x) >> 12) & 7)
#define MFrom(x)          ((x)&63)
#define MTo(x)            (((x)>>6)&63)
#define NO_MOVE           (MOVE)(-1)

/* Store the undo information for a move */
typedef struct Undo {
  char ep;         /* The old E-P square, or -1 */
  char capt;       /* The piece captured in the move, or 0 */
  BITBOARD R90,R45,L45; /* The old rotated bitboards - saves recreating them */
}Undo;


/*    -----===  Board Structure Storage Class  ===-----  */


 /* Removes the indicated piece from the board. 
  * The XOR is a little naughty, and fails if the piece doesn't exist! */
#define Remove(a,b)  ((a) = (a^(UNIT<<b)))
 /* Remove the first piece */
#define RemoveFirst(a)   ((a) = ((a) & ((a)-1)))
  /* Miscellaneous Board defines */
#define UNIT   ((BITBOARD)1)
#define EMPTY  ((BITBOARD)0)

/* A Structure to Store the Current State of the Board */
typedef struct Board {
  BITBOARD All;  /* Every piece on the board */
  BITBOARD R90,R45,L45; /* Every piece on the board rotated */
  BITBOARD BlackPieces, WhitePieces;
  BITBOARD BlackPawns, WhitePawns;
  BITBOARD BlackRooks, WhiteRooks;
  BITBOARD BlackKnights, WhiteKnights;
  BITBOARD BlackBishops, WhiteBishops;
  BITBOARD BlackQueens, WhiteQueens;
  int WhiteKing,BlackKing;  /* King square positions */
  signed char pieces[64];  /* Array of pieces.  Much nicer :) */
  int ep; /* En-passant square */
  int side; /* Side to move */
}Board;

#endif /* COMMON_H */
