/**********************************
 *    setup.c                     *
 *    Colin Frayn                 *
 *    June 2002                   *
 **********************************/

/*
  Initialise all the data structures needed for the 
  move generation etc...
 */ 

#include "stdafx.h"
#include "common.h"
#include "setup.h"
#include "defs.h"

/* Setup the precalculated bitboards that we're going to need
 * later on in the game */
void SetupPrecalculatedData(void) {
  BITBOARD rank=FullRank,mask,mask2;
  int i,j,x,rankno,filenum,diagstart,dsfile,dl,fi;

  Randomise();

  /* Rank and File Masks */
  for (i=0;i<8;i++) {
    FileMask[i] = 0;
    for (j=i;j<64;j+=8) FileMask[i] += (UNIT<<j);
    RankMask[i] = (rank << (8*i));
  }
   
   /* Masks for the FirstPiece algorithm */
  FPMask1 = (BITBOARD)TwoFullRanks << 16;
  FPMask2 = (BITBOARD)TwoFullRanks << 32;
   
   /* Masks for the squares on a file above (or below) the specified square */
  for (i=0;i<64;i++) {
    FileUpMask[i] = FileDownMask[i] = 0;
    for (j=i-8;j>=0;j-=8) FileUpMask[i] += (UNIT << j);
    for (j=i+8;j<64;j+=8) FileDownMask[i] += (UNIT << j);
  }

   /* Square Masks */
  for (i=0;i<64;i++) {
    Mask[i] = (UNIT<<i);
    InvMask[i] = ~Mask[i];
  }

   /* Diagonal Masks */
  for (i=0;i<64;i++) {
    DiagMaska1h8[i] = DiagMaska8h1[i] = 0;
     /* a1h8 direction first */
    diagstart = 7*(min((File(i)),7-(Rank(i)))) + i;
    for (j=0;j<DiagonalLength_a1h8[i];j++) {
      DiagMaska1h8[i] += (UNIT << (diagstart - j*7));
    }
     /* a8h1 direction next */
    diagstart = i - 9*(min((File(i)),(Rank(i))));
    for (j=0;j<DiagonalLength_a8h1[i];j++) {
      DiagMaska8h1[i] += (UNIT << (diagstart + j*9));
    }
  }

   /* Setup inverse transformation matrices */
  for (i=0;i<64;i++) {
    InvRotateL45[(RotateL45[i])]=i;
    InvRotateR45[(RotateR45[i])]=i;
  }

   /* Setup masks for diagonal sliding pieces */
  for (i=0;i<64;i++) {
    DiagonalMask_a1h8[i] = (1 << DiagonalLength_a1h8[i])-1;
    DiagonalMask_a8h1[i] = (1 << DiagonalLength_a8h1[i])-1;
  }
   
   /* And similarly, these are just a few masks I need later on to save a few ops ;) */
  for (i=0;i<64;i++) {
    MR90[i] = Mask[(RotateL90[i])];
    IMR90[i] = InvMask[(RotateL90[i])];
    MR45[i] = Mask[(InvRotateR45[i])];
    IMR45[i] = InvMask[(InvRotateR45[i])];
    ML45[i] = Mask[(InvRotateL45[i])];
    IML45[i] = InvMask[(InvRotateL45[i])];
  }

   /* This one effectively flips the y-coord */
  for (i=0;i<64;i++) {
    Flip[i] = ((7-Rank(i))*8) + File(i);
  }

   /* Lookup tables for the first- & last- piece functions */
  for (i=0;i<65536;i++) {
     /* First piece in a two rank chunk */
    for (j=0;j<16;j++) {
      if (i&(1<<j)) {first_piece[i] = j; break;}
    }
     /* Last piece in a two rank chunk */
    for (j=15;j>=0;j--) {
      if (i&(1<<j)) {last_piece[i] = j; break;}
    }
  }
   
   /* Pawn Moves */
  for (i=0;i<64;i++) {
    PawnAttacksBlack[i] = PawnAttacksWhite[i] = 0;
    PawnMovesBlack[i] = PawnMovesWhite[i] = 0;
    if (File(i)>0) {
      if (i<a1) PawnAttacksBlack[i] += (UNIT<<(i+7));
      if (i>7) PawnAttacksWhite[i] += (UNIT<<(i-9));
    }
    if (File(i)<7) {
      if (i<a1) PawnAttacksBlack[i] += (UNIT<<(i+9));
      if (i>7) PawnAttacksWhite[i] += (UNIT<<(i-7));
    }
    if (Rank(i)==0 || Rank(i)==7) continue;
    PawnMovesBlack[i] += (UNIT<<(i+8));
    PawnMovesWhite[i] += (UNIT<<(i-8));
    if (Rank(i)==1) PawnMovesBlack[i]+=(UNIT<<(i+16));
    if (Rank(i)==6) PawnMovesWhite[i]+=(UNIT<<(i-16));
  }
   /* Knight Moves */
  for (i=0;i<64;i++) {
    KnightMoves[i]=0;
    if (Rank(i)>0) {
      if (Rank(i)>1) {
        if (File(i)>0) KnightMoves[i] += (UNIT<<(i-17)); 
        if (File(i)<7) KnightMoves[i] += (UNIT<<(i-15)); 
      }
      if (File(i)>1) KnightMoves[i] += (UNIT<<(i-10));
      if (File(i)<6) KnightMoves[i] += (UNIT<<(i-6));
    }
    if (Rank(i)<7) {
      if (Rank(i)<6) {
        if (File(i)>0) KnightMoves[i] += (UNIT<<(i+15)); 
        if (File(i)<7) KnightMoves[i] += (UNIT<<(i+17)); 
      }
      if (File(i)>1) KnightMoves[i] += (UNIT<<(i+6));
      if (File(i)<6) KnightMoves[i] += (UNIT<<(i+10));
    }
  }
   /* King Moves */
  for (i=0;i<64;i++) {
    KingMoves[i]=0;
    if (Rank(i)>0) {
      if (File(i)>0) KingMoves[i] += (UNIT<<(i-9));
      if (File(i)<7) KingMoves[i] += (UNIT<<(i-7));
      KingMoves[i] += (UNIT<<(i-8));
    }
    if (Rank(i)<7) {
      if (File(i)>0) KingMoves[i] += (UNIT<<(i+7));
      if (File(i)<7) KingMoves[i] += (UNIT<<(i+9));
      KingMoves[i] += (UNIT<<(i+8));
    }
    if (File(i)>0) KingMoves[i] += (UNIT<<(i-1));
    if (File(i)<7) KingMoves[i] += (UNIT<<(i+1));
  }
   /* Sliding Piece Move Masks. Note that this includes being able to
    * 'capture' friendly pieces and kings.  These are filtered out 
    * later with an AND in the move generation routine.  Basically, 
    * for each square on the board, generate every possible rank using
    * 1 for occupied and 0 for empty.  This gives a list of all possible
    * occupation states from 0-255 for that rank.  Then generate the
    * possible move bitboard for each of these configurations.
    */

   /* Horizontal Sliders */
  for (filenum=0;filenum<8;filenum++) {
    for (j=0;j<256;j++) {
      mask=0;
      for (x=filenum-1;x>=0;x--) {
        mask += (UNIT<<x);
        if (j & (1<<x)) break;
      }
      for (x=filenum+1;x<8;x++) {
        mask += (UNIT<<x);
        if (j & (1<<x)) break;
      }
      for (rankno=0;rankno<8;rankno++)
        MovesRank[(rankno*8)+filenum][j] = mask<<(rankno*8);
    }
  }
   /* Vertical Sliders */
  for (rankno=0;rankno<8;rankno++) {
    for (j=0;j<256;j++) {
      mask=0;
      for (x=6-rankno;x>=0;x--) {
        mask += (UNIT<<(8*(7-x)));
        if (j & (1<<x)) break;
      }
      for (x=8-rankno;x<8;x++) {
        mask += (UNIT<<(8*(7-x)));
        if (j & (1<<x)) break;
      }
      for (filenum=0;filenum<8;filenum++)
        MovesFile[(rankno*8)+filenum][j] = mask << filenum;
    }
  }

   /* Now here is where is gets rather nasty.
    * Generate the possible moves for bishops (and queens) using
    * 45 degrees rotated bitboards, both right and left rotated for
    * the two perpendicular diagonal directions. A bit scary. */
  
   /* a1h8 Diagonal Sense first. Note all diagonals are of
    * different lengths, precalculated in common.h. */
  for (i=0;i<64;i++) {
     /* Get the far left hand square on this diagonal */
    diagstart = 7*(min((File(i)),7-(Rank(i)))) + i;
    dsfile = File(diagstart);
    dl = DiagonalLength_a1h8[i];
    fi = File(i);
     /* Loop through all possible occupations of this diagonal line */
    for (j=0 ; j < (1 << dl) ; j++) {
      mask=mask2=0;
       /* Calculate possible target squares */
      for (x=(fi-dsfile)-1;x>=0;x--) {
        mask += (UNIT<<x);
        if (j & (1<<x)) break;
      }
      for (x=(fi-dsfile)+1;x<dl;x++) {
        mask += (UNIT<<x);
        if (j & (1<<x)) break;
      }
       /* Rotate the target line back onto the required diagonal */
      for (x=0;x<dl;x++)
        mask2 += ( ((mask >> x) & 1) << (diagstart-(7*x)) ) ;
      Movesa1h8[i][j] = mask2;
    }
  }
   
   /* a8h1 Diagonal Sense */
  for (i=0;i<64;i++) {
     /* Get the far left hand square on this diagonal */
    diagstart = i - 9*(min((File(i)),(Rank(i))));
    dsfile = File(diagstart);
    dl = DiagonalLength_a8h1[i];
    fi = File(i);
     /* Loop through all possible occupations of this diagonal line */
    for (j=0 ; j < (1 << dl) ; j++) {
      mask=mask2=0;
       /* Calculate possible target squares */
      for (x=(fi-dsfile)-1;x>=0;x--) {
        mask += (UNIT<<x);
        if (j & (1<<x)) break;
      }
      for (x=(fi-dsfile)+1;x<dl;x++) {
        mask += (UNIT<<x);
        if (j & (1<<x)) break;
      }
       /* Rotate target squares back */
      for (x=0;x<dl;x++)
        mask2 += ( ((mask >> x) & 1) << (diagstart+(9*x)) ) ;
      Movesa8h1[i][j] = mask2;
    }
  }

   /* Finally, make sliding mask templates, or equivalent to
    * all possible queen moves on an open board from this position */
  for (i=0;i<64;i++) {
    RookMask[i]   = MovesRank[i][empty] | MovesFile[i][empty];
    BishopMask[i] = Movesa1h8[i][empty] | Movesa8h1[i][empty];
    QueenMask[i]  = RookMask[i] | BishopMask[i];
                     
  }

   /* Phew */
}
