// MateTest.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "MateTest.h"
#include "setup.h"
#include "resource.h"
#include "common.h"
#include "generate.h"


// Global Variables:
HINSTANCE g_hInst;		  				    // current instance
TCHAR szTitle[]="Mate Tests";				// The title bar text
TCHAR szWindowClass[]="MateTest";	  // The (other) title bar text
HWND hWndMain;
BOOL bCheck=TRUE, bCapt=TRUE, bOneSol=TRUE, bPromote=TRUE;
extern char **SolList;

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow) {
  MSG msg;
  HWND hDlg;
  g_hInst = hInstance;
  
  // Display the main dialog box.
  hDlg = CreateDialog(hInstance, MAKEINTRESOURCE(IDD_DIALOG), NULL, WndProc);
  ShowWindow(hDlg,SW_SHOW);
  hWndMain = hDlg;

  // Setup the data that we will need later on for generating moves etc.
  SetupPrecalculatedData();
  SolList = NULL;

  // Message loop
	while (GetMessage(&msg, NULL, 0, 0)) {
    if(!IsDialogMessage(hDlg, &msg)) {
      TranslateMessage(&msg); 
      DispatchMessage(&msg); 
    }    
    if(msg.message == WM_QUIT) {
      DestroyWindow( hDlg );
    	return msg.wParam;
    }
  }
	return msg.wParam;
}

#define UPDATE_TIMER  1

// Main window messaging function
INT_PTR CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
  int wmId, wmEvent, n;
  static int pieces[13]={1,0,0,0,0,0,0,0,0,0,0,1,1}, depth=2, lastdepth=0;
  static BOOL bRun = FALSE;
  static int nfound = 0, ntry = 0, npos = 0;
  HDC hDC;
  PAINTSTRUCT ps;

  switch (message) {
    case WM_CREATE:
      return TRUE;
    case WM_INITDIALOG:
      SendDlgItemMessage(hWnd, IDC_LIST, LB_RESETCONTENT, 0, 0);
      SetDlgItemInt(hWnd, IDC_NFOUND, 0, FALSE);
      SetDlgItemInt(hWnd, IDC_NTESTED, 0, FALSE);
      DisplayDialog(hWnd, pieces);
      SetDlgItemText(hWnd, IDC_SAVE, "");
       // Set up a timer control for the periodic updates
      SetTimer(hWnd,UPDATE_TIMER,25,NULL);
      break;
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// Parse the menu selections:
      switch (wmId) {
        case IDC_WQU: if (pieces[wqueen+6]<2) pieces[wqueen+6]++; break;
        case IDC_WQD: if (pieces[wqueen+6]>0) pieces[wqueen+6]--; break;
        case IDC_WRU: if (pieces[wrook+6]<2) pieces[wrook+6]++; break;
        case IDC_WRD: if (pieces[wrook+6]>0) pieces[wrook+6]--; break;
        case IDC_WNU: if (pieces[wknight+6]<2) pieces[wknight+6]++; break;
        case IDC_WND: if (pieces[wknight+6]>0) pieces[wknight+6]--; break;
        case IDC_WBU: if (pieces[wbishop+6]<2) pieces[wbishop+6]++; break;
        case IDC_WBD: if (pieces[wbishop+6]>0) pieces[wbishop+6]--; break;
        case IDC_WPU: if (pieces[wpawn+6]<8) pieces[wpawn+6]++; break;
        case IDC_WPD: if (pieces[wpawn+6]>0) pieces[wpawn+6]--; break;
        case IDC_BQU: if (pieces[bqueen+6]<2) pieces[bqueen+6]++; break;
        case IDC_BQD: if (pieces[bqueen+6]>0) pieces[bqueen+6]--; break;
        case IDC_BRU: if (pieces[brook+6]<2) pieces[brook+6]++; break;
        case IDC_BRD: if (pieces[brook+6]>0) pieces[brook+6]--; break;
        case IDC_BNU: if (pieces[bknight+6]<2) pieces[bknight+6]++; break;
        case IDC_BND: if (pieces[bknight+6]>0) pieces[bknight+6]--; break;
        case IDC_BBU: if (pieces[bbishop+6]<2) pieces[bbishop+6]++; break;
        case IDC_BBD: if (pieces[bbishop+6]>0) pieces[bbishop+6]--; break;
        case IDC_BPU: if (pieces[bpawn+6]<8) pieces[bpawn+6]++; break;
        case IDC_BPD: if (pieces[bpawn+6]>0) pieces[bpawn+6]--; break;
          // Mate depth
        case IDC_DEPTH:
          if (!bRun) {
            depth++;
            if (depth>3) depth=1;
            if (depth == 1) SetDlgItemText(hWnd, IDC_DEPTH, "M1");
            if (depth == 2) SetDlgItemText(hWnd, IDC_DEPTH, "M2");
            if (depth == 3) SetDlgItemText(hWnd, IDC_DEPTH, "M3");
          }
          break;
          // Save the list
        case IDC_SAVE:
          if (!bRun && lastdepth>0) SaveList(lastdepth);
          break;
        case IDC_ABORT:
          bRun = FALSE;
          break;
        case IDC_GENERATE:
          pieces[bqueen+6] = GetDlgItemInt(hWnd, IDC_BQ, NULL, FALSE);
          pieces[brook+6] = GetDlgItemInt(hWnd, IDC_BR, NULL, FALSE);
          pieces[bknight+6] = GetDlgItemInt(hWnd, IDC_BN, NULL, FALSE);
          pieces[bbishop+6] = GetDlgItemInt(hWnd, IDC_BB, NULL, FALSE);
          pieces[bpawn+6] = GetDlgItemInt(hWnd, IDC_BP, NULL, FALSE);
          pieces[wqueen+6] = GetDlgItemInt(hWnd, IDC_WQ, NULL, FALSE);
          pieces[wrook+6] = GetDlgItemInt(hWnd, IDC_WR, NULL, FALSE);
          pieces[wknight+6] = GetDlgItemInt(hWnd, IDC_WN, NULL, FALSE);
          pieces[wbishop+6] = GetDlgItemInt(hWnd, IDC_WB, NULL, FALSE);
          pieces[wpawn+6] = GetDlgItemInt(hWnd, IDC_WP, NULL, FALSE);
          pieces[wking+6] = pieces[bking+6] = 1;
          pieces[empty+6] = 0;
          if (IsDlgButtonChecked(hWnd, IDC_CHECK)) bCheck = TRUE;
          else bCheck = FALSE;
          if (IsDlgButtonChecked(hWnd, IDC_CAPT)) bCapt = TRUE;
          else bCapt = FALSE;
          if (IsDlgButtonChecked(hWnd, IDC_ONESOL)) bOneSol = TRUE;
          else bOneSol = FALSE;
          if (IsDlgButtonChecked(hWnd, IDC_PROMOTE)) bPromote = TRUE;
          else bPromote = FALSE;
          SetDlgItemInt(hWnd, IDC_NFOUND, 0, FALSE);
           // Reset the lists
          if (npos>0) {
            for (n=0;n<npos;n++) free(SolList[n]);
            free(SolList);
          }
          npos = GetDlgItemInt(hWnd, IDC_NPOS, NULL, FALSE);
          SolList = (char **)malloc(sizeof(char *) * npos);
          for (n=0;n<npos;n++) SolList[n] = (char *)malloc(sizeof(char) * 64);
          SendDlgItemMessage(hWndMain, IDC_LIST, LB_RESETCONTENT, 0, 0);
          ntry = nfound = 0;
          bRun = TRUE;
          lastdepth = depth;
          SetDlgItemText(hWnd, IDC_SAVE, "Save");
          break;
  	    case IDOK:
		     // fall through
        case IDCANCEL:
          KillTimer(hWnd, UPDATE_TIMER);
          PostQuitMessage(IDCANCEL);
   		    return TRUE;
				default:
				  return DefWindowProc(hWnd, message, wParam, lParam);
			}
      DisplayDialog(hWnd, pieces);
			break;
		case WM_PAINT:
			hDC = BeginPaint(hWnd, &ps);
      ReleaseDC(hWnd, hDC);
			break;
		case WM_DESTROY:
			break;
    // Do the timer functions
    case WM_TIMER:
      if (bRun) ntry = Generate(pieces, npos, &nfound, ntry, depth);
      if (nfound == npos) bRun = FALSE;
      break;
		default:
      return FALSE;
   }
    // Check defaults
   if (GetDlgItemInt(hWnd, IDC_NPOS, NULL, FALSE) < 1) SetDlgItemInt(hWnd, IDC_NPOS, 1, FALSE);
   return FALSE;
}

// Display the options for the dialog box
void DisplayDialog(HWND hWnd, int *pieces) {
  SetDlgItemInt(hWnd, IDC_WQ, pieces[wqueen+6], FALSE);
  SetDlgItemInt(hWnd, IDC_WR, pieces[wrook+6], FALSE);
  SetDlgItemInt(hWnd, IDC_WN, pieces[wknight+6], FALSE);
  SetDlgItemInt(hWnd, IDC_WB, pieces[wbishop+6], FALSE);
  SetDlgItemInt(hWnd, IDC_WP, pieces[wpawn+6], FALSE);
  SetDlgItemInt(hWnd, IDC_BQ, pieces[bqueen+6], FALSE);
  SetDlgItemInt(hWnd, IDC_BR, pieces[brook+6], FALSE);
  SetDlgItemInt(hWnd, IDC_BN, pieces[bknight+6], FALSE);
  SetDlgItemInt(hWnd, IDC_BB, pieces[bbishop+6], FALSE);
  SetDlgItemInt(hWnd, IDC_BP, pieces[bpawn+6], FALSE);
}

// Get a file name for saving the FEN list as EPD
void GetSuitableFile(char *strTemp) {
  OPENFILENAME ofn;
  char szFile[FILENAME_MAX]="";

  ZeroMemory(&ofn, sizeof(OPENFILENAME));
  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = hWndMain;
  ofn.lpstrFile = szFile;
  ofn.nMaxFile = sizeof(szFile);
  ofn.lpstrFilter = "All\0*.*\0EPD Files\0*.epd\0";
  ofn.lpstrCustomFilter = NULL;
  ofn.nFilterIndex = 1;
  ofn.lpstrFileTitle = NULL;
  ofn.nMaxFileTitle = 0;
  ofn.lpstrInitialDir = NULL;
  ofn.Flags = OFN_PATHMUSTEXIST|OFN_HIDEREADONLY;

  if (GetOpenFileName(&ofn) == FALSE) strcpy(strTemp,"");
  strcpy(strTemp,szFile);
}

// Save the current FEN list as an EPD file
void SaveList(int depth) {
  int n, npos;
  char strTemp[FILENAME_MAX];
  FILE *fp;

  GetSuitableFile(strTemp);

  if (!strcmp(strTemp,"")) return;

  if ((fp = fopen(strTemp, "w")) == NULL) {
    MessageBox(hWndMain, "Cannot open file for writing","File Error", MB_OK);
    return;
  }

  npos = SendDlgItemMessage(hWndMain, IDC_LIST, LB_GETCOUNT, 0, 0);

  for (n=0;n<npos;n++) {
    SendDlgItemMessage(hWndMain, IDC_LIST, LB_GETTEXT, n, (long)strTemp);
    fprintf(fp,"%s bm %s; id \"Mate in %d Test %d\";\n",strTemp,SolList[n],depth,n+1);
  }

  fclose(fp);
}